// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/vr_service.mojom
//

package org.chromium.mojom.content;

public final class VrFieldOfView extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public float upDegrees;
    public float downDegrees;
    public float leftDegrees;
    public float rightDegrees;

    private VrFieldOfView(int version) {
        super(STRUCT_SIZE, version);
    }

    public VrFieldOfView() {
        this(0);
    }

    public static VrFieldOfView deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static VrFieldOfView decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        VrFieldOfView result = new VrFieldOfView(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.upDegrees = decoder0.readFloat(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.downDegrees = decoder0.readFloat(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.leftDegrees = decoder0.readFloat(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.rightDegrees = decoder0.readFloat(20);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(upDegrees, 8);
        encoder0.encode(downDegrees, 12);
        encoder0.encode(leftDegrees, 16);
        encoder0.encode(rightDegrees, 20);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        VrFieldOfView other = (VrFieldOfView) object;
        if (this.upDegrees != other.upDegrees)
            return false;
        if (this.downDegrees != other.downDegrees)
            return false;
        if (this.leftDegrees != other.leftDegrees)
            return false;
        if (this.rightDegrees != other.rightDegrees)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(upDegrees);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(downDegrees);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(leftDegrees);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(rightDegrees);
        return result;
    }
}

